'Dataset Germany Quarterly 1991:1 2011:4
'bung NVWM & IPuW
open d9111q4_pbl.wf1
save d9111q4t.wf1
close d9111q4_pbl.wf1

'ALLGEMEINE UND SPEZIELLE SIMULATIONS-VARIBALEN'
series a0dum = 0
series a0zinsk = 0
series a0zinsl = 0
series a0yavhh = 0
series a0wtrade = 0
series a0cst = 0

'Sttzbereich
smpl 2002:1 2011:3

'Verhaltensgleichungen

'Konsumfunktion 
equation _eq_10.ls  cprivp  = c(1) + c(2)*yavhh/cpripe*100 + c(7)*dq1 + c(8)*dq2 + c(9)*dq3

'Staatskonsum
equation _eq_20.ls cstvp - a0cst = c(1) + c(2)*(cstvp(-1) - a0cst(-1)) + c(3)*txan + c(7)*dq1 + c(8)*dq2 + c(9)*dq3

'Investitionsfunktion
equation _eq_30.ls ibvp  = c(1) + c(2)*bipvp + c(7)*dq1 + c(8)*dq2 + c(9)*dq3

'Exportfunktion
equation _eq_40.ls exvp = c(1) + c(2)*tot + c(3)*wtrade(-1) + c(7)*dq1 + c(8)*dq2 + c(9)*dq3

'Importfunktion
equation _eq_50.ls imvp = c(1) + c(2)*cprivp + c(3)*exvp(-1) 

'Produktionsfunktion
equation _eq_60.ls bipvp = c(1) + c(2)*azaninl + c(3)*vanb2k + c(4)*apewki + c(7)*dq1 + c(8)*dq2 + c(9)*dq3

model _M
'Verhaltensgleichungen
_M.merge _eq_10
_M.merge _eq_20
_M.merge _eq_30
_M.merge _eq_40
_M.merge _eq_50

'Identitten
_M.append BIPVP = CPRIVP + CSTVP + IBVP + EXVP - IMVP

_M.scenario(n, a=bas) "BAS"
_M.solve

stop

'VORGABEN DER SIMULATION'
smpl 2004q1 2004q4

'ERHHUNG DES STAATSKONSEMS UM 4 MRD
'A0DUM.fill(I) 0
'A0DUM.fill(s,l) 1.00
'a0cst = a0cst + a0dum

'ERHHUNG DES VERFGBAREN EINKOMMENS UM 4 MILLIARDEN'
'A0DUM.fill(I) 0
'A0DUM.fill(s,l) 1
'yavhh = yavhh + a0dum

'RCKGANG DES WELTHANDELS UM 10 MILLIARDEN'
'A0DUM.fill(I) 0
'A0DUM.fill(s,l) -2.5
'wtrade = wtrade + a0DUM

'SCENARIO SIMULATIONEN
smpl 2002q1 2011q3

_M.scenario(n, a=sim) "SIM"
_M.solve

smpl 2000q1 2011q3

call routine("cprivp", 1)
call routine("cstvp", 2)
call routine("ibvp",3)
call routine("exvp",4)
call routine("imvp",5)
call routine("bipvp",6)

'_________________________________________
'Graph. Darstellung

subroutine routine(string %var, scalar !nr)

%var_bas = %var + "_BAS"
%var_sim = %var + "_SIM"
%var_dif = %var + "_dif"
%var_dif_r = %var + "_dif_r"
%graph1 = "_graph_"  + @str(!nr)
series {%var_dif} = {%var_sim} - {%var_bas}  
series {%var_dif_r} = ({%var_sim}-{%var_bas})/{%var_bas}*100

'Graphische Darstellung der Modellsung
graph {%graph1}.line(d) {%var_dif} {%var_bas} {%var_sim}
{%graph1}.draw(dashline, left) 0.0
{%graph1}.option linepat
{%graph1}.setelem(1) lpat(1) lcolor(red)
{%graph1}.setelem(2) lpat(5) lcolor(green)
{%graph1}.setelem(3) lpat(1) lcolor(blue)
{%graph1}.addtext(t,font=16) Baseline and Simulation
show {%graph1}

endsub

graph _graph_all.merge _graph_1 _graph_2 _graph_3 _graph_4 _graph_5 _graph_6
show _graph_all
